<?php 
    

function post_is_in_descendant_category( $cats, $_post = null ){
    foreach ( (array) $cats as $cat ) {
        // get_term_children() accepts integer ID only
        $descendants = get_term_children( (int) $cat, 'category');
        if ( $descendants && in_category( $descendants, $_post ) )
            return true;
    }
    return false;
}    
    
function woo_thumb_url($url,$width = 200, $height = null){
	
	$src = get_bloginfo('template_url') . '/thumb.php?src=' . $url . '&amp;w=' .$width . '&amp;h=' . $height . '&amp;zc=1&amp;q=90';
	
	return $src ;
	
}

function woo_attachments($instance = null,$image_w = 72,$image_h = 72,$limit_images = 6){          


       $post_id = $instance['post_id'];
       $post_id_select = $instance['post_id_select'];
       $cat_id = $instance['cat_id'];
       $widget_title = $instance['title'];
       $image_title = $instance['image_title'];
       $image_caption = $instance['image_caption'];
       $size = $instance['size'];
       $rows = $instance['rows'];
       $max = $limit_images; // Edit
       $lb = $instance['lightbox'];
       $auto = $instance['auto'];
       $speed = $instance['speed'];
	   
	   
       
       $wp_resized_image = get_option('woo_wp_attachment');
       
       
	   //Get the attachments for the Category posts.
       if(!empty($cat_id)){
       	 $category = true;
       	 $cat_data = get_category($cat_id, ARRAY_A);
       	 $post_id = $cat_data['slug'];
       }
       if($category == true){
       	$posts = get_posts('cat='.$cat_id .'&numberposts=' . $max);
       	$cat_counter = 0;
       	
       	foreach($posts as $post){
       	//print_r($posts);
       		$cat_counter++;
	       	$single_attachment = get_children( array(
	            'post_parent' => $post->ID, 
	            'post_status' => 'inherit', 
	            'post_type' => 'attachment', 
	            'post_mime_type' => 'image', 
                'order' => 'ASC', 
                'orderby' => 'menu_order date', 
	            'numberposts' => 1,
	            ));
	           
	         if($cat_counter == 1){
	         	$attachments = $single_attachment;
	         }else{
	        	$attachments = array_merge($attachments, $single_attachment);
	         }
       	}
       } 
       else {
	   if($max == "") { $max = 999;}	
       $attachments = get_children( array(
            'post_parent' => $post_id, 
            'post_status' => 'inherit', 
            'post_type' => 'attachment', 
            'post_mime_type' => 'image', 
            'order' => 'ASC', 
            'orderby' => 'menu_order date', 
            'numberposts' => $max,
            ));
        }
        
			
		$items = count($attachments);
			
		//Slider
		if($rows > 0) { $slider = true;}
		
		if($slider == true){
			if($size == 'small'){ $viewable = 4 * $rows; }
			if($size == 'medium'){ $viewable = 3 * $rows; }
			if($size == 'large'){ $viewable = 2 * $rows; }
			if($size == 'full'){ $viewable = 1 * $rows; }
		}
		
		if($viewable >= $items) {$slider = false;}
	
       //Lightbox
       if ($lb == 'true' OR $lb == 'on'){$lightbox = true;}
       else {$lightbox = false;}
       
         
      $counter = 3;
      $iter = 0;
	  $loop = 0;
      if(empty($attachments)){
	  
	  return false; // Bail is there is no attachments
	  
	  }
	  
       $items = count($attachments);
       foreach ( $attachments as $attachment ) {
        $counter++;
		$loop++;
		
		$id = $attachment->ID;

        //Image Setup
        $link = get_attachment_link($id);
        $src = wp_get_attachment_image_src($id, 'large', true); // Thumb.php makes use of the Largest wordpres image and not the source file.
        //print_r($src);
        $full_image = $src[0];
        
        //Content Setup
        $att_title = $attachment->post_title;
        $att_caption = $attachment->post_excerpt;
        $att_content = $attachment->post_content;
        $att_comments = $attachment->comment_count;

            //Setup what goes where
            if($image_title == 'off'){$title = '';}
            elseif($image_title == 'title'){$title = $att_title;}
            elseif ($image_title == 'caption'){$title = $att_caption;}
            elseif ($image_title == 'description'){$title = $att_content;}
            
            if($image_caption == 'off'){$content = '';}
            elseif($image_caption == 'title'){$content = $att_title;}
            elseif ($image_caption == 'caption'){$content = $att_caption;}
            elseif ($image_caption == 'description'){$content = $att_content;}
        
        //Size
        if($size == 'small'){$w = 212; $h = 212; $l = 7; $per_row = 4;}
        elseif($size == 'medium'){$w = 280; $h = 320; $l = 6; $per_row = 3;}
        elseif($size == 'large'){$w = 440; $h = 220; $l = 5; $per_row = 2;}
        elseif($size == 'full'){$w = 920; $h = 506; $l = 4; $per_row = 1;}
        elseif($size == 'thumb'){$w = $image_w; $h = $image_h; $l = 7; $per_row = 1;}
        
        //MOD
        if($l == 4) {$mod = ' full first last';}
        else {
            if($counter%4 == 0)
            {$mod = ' first';}
             elseif($counter%$l == 0)
             {$mod = ' last';} 
             else{$mod = '';};
            if($counter == $l) $counter = 3;
        }
        

		
		if(($iter == 0 ) && $slider == true){$images .= '<div class="slide">' . "\n";}// Slider wrap
		
		$iter++;
        
        $img_url = woo_thumb_url($full_image,$w,$h);
        if($size == 'full' AND $wp_resized_image == 'true'){ $img_url = $full_image;}
		
        $images .= '<div class="image_box'. $mod .'">' . "\n";
        if($lightbox == false AND $att_comments != 0) //$images .= '<span class="date"><a href="'.$link.'">'. $att_comments . '</a></span>' . "\n";
            if(($image_title == 'off' AND $image_caption == 'off') OR ($title == '' AND $content == '')){
                //When there is no content for image caption or both is turned off
            } 
            else{
            
                $images .= '<div class="text">' . "\n";
                    if($image_title != 'off') 
                    {
                        if($lightbox) {
                            //$images .= '<h2><a title="'. $title .'" href="'. $link .'">'. $title .'</a></h2>' . "\n"; 
                            $images .= '<h3><a title="'. $title .'" rel="lightbox['.$post_id.']" href="'.  $full_image .'">'. $title .'</a></h3>'. "\n";;
                        } else {     
                            $images .= '<h3><a title="'. $title .'" href="'. $link .'">'. $title .'</a></h3>' . "\n";
                        }
                    }
                    if($image_caption != 'off') {
                      if($lightbox) {  
                            $images .= '<p><a title="'. $content .'" rel="lightbox['.$post_id.']" href="'.  $full_image .'">'. $content .'</a></p>' . "\n";
                      } else {
                            $images .= '<p><a title="'. $content .'" href="'.  $link .'">'. $content .'</a></p>' . "\n"; 
                      }
                    }
                    
                $images .= '</div>' . "\n";
            }
        

            
        if($lightbox){
            $images .= '<a title="' . get_the_title($id) .'" rel="lightbox['.$post_id.']" href="'.  $full_image /* Max upload size in WP? OR Thumb.php? -> exposure_thumb_url($full_image,920,600) */ .'"><img src="'. $img_url .'" width="'.$w.'" alt="'.get_the_title($id).'" /></a>';   
        } else {
            $images .= '<a href="'. $link .'"><img width="'.$w.'" src="'. $img_url .'" alt="'.get_the_title($id).'" /></a>';
        }

        $images .= '</div>' . "\n";
     	
        if(($iter == $viewable || $loop == $items ) && $slider == true){$images .= '</div>'; $iter = 0;}// Slider wrap
       }
	   
	   //Start Output building
       $output = '';
       $output .= '<div class="unit picture-unit">';

       //Heading
       $output .= '<div class="heading">';
	   
	   if($widget_title == '' AND $category == false) { $widget_title = get_the_title($post_id);}
	   //else { $widget_title = get_the_title($post_id);}
	   if($category == true AND $widget_title == ''){
	   // $output .= '<h2><a href="'. get_category_link($cat_id).'">'. get_cat_name($cat_id) .'</a></h2>';
	   }
	   elseif ($widget_title != '' AND $category == true){
	   	//   $output .= '<h2><a href="'. get_category_link($cat_id).'">'. $widget_title .'</a></h2>';
	   }
       elseif (!is_single() && !is_page()){
       //    $output .= '<h2><a href="'. get_permalink($post_id).'">'. $widget_title .'</a></h2>';
       }
       else {
       //    $output .= '<h2>'. $widget_title .'</h2>';
       }
        //$output .= '<a href="#" title="#" class="title_rss">RSS feed (optional)</a>'; ?
       $output .= '<div class="clear"></div>';
       $output .= '</div>' . "\n";
       
	   if($slider == true){
	   		$output .= '<div id="slider-'. $post_id .'">'. "\n" . '<div class="container">'. "\n" . '<div class="slides">'. "\n";
	   }
       //Images
       $output .= $images;
	   
	   if($slider == true){
	   		$output .= "</div>\n</div>\n";
			$output .= '<a class="slider_left previous" href="#" title="Navigate left">PREV</a>';
			$output .= 	'<a class="slider_right next" href="#" title="Navigate right">NEXT</a>' . "\n";
			$output .= "</div>\n";
			
	   }
       
       $output .= '<div class="clear"></div>' . "\n";
	   /* $output .= '<script type="text/javascript">jQuery(window).load(function(){ jQuery("#slider-'. $post_id . '").loopedSlider({autoStart:'.get_option('woo_slider_auto').', slidespeed:'.get_option('woo_slider_speed').'});});</script>'; // Init slider wth inline JS */
	   $output .= '</div>';
       return $output;
    
      
      }

function woo_mp3_player($id,$audio_w = 220,$audio_h = 19,$limit_players = 0,$widget_id = ''){  
      
 $id = intval($id);
    $attachments = get_children( array(
            'post_parent' => $id, 
            'post_status' => 'inherit', 
            'post_type' => 'attachment', 
            'post_mime_type' => 'audio', 
            'order' => $order, 
            'orderby' => $orderby,
            ));
           
    if ( empty($attachments) )
        return false;
   	
   	//Defaults
    $volume = "50";
    $auto = "false";
    $repeat = "false";
    
    //Custom
    $back = get_option('woo_player_back');
    $front = get_option('woo_player_front');
    $light = get_option('woo_player_light');
    $link = get_option('woo_player_link');
    $captions = get_option('woo_player_captions');
    
    $counter = 0;    
    $output .=  '<div class="unit audio-unit">'; 

      foreach ($attachments as $id => $attachment ) {
       $counter++;
       $post_id = $attachment->ID;
	   
	   $widget_id = str_replace('-','_',$widget_id);
	   if($widget_id != ''){ $post_id = $post_id . '_' . $widget_id . '_';}
	       
       $title = trim($attachment->post_title);
       $caption = trim($attachment->post_excerpt);
       $path = $attachment->guid;
       $duration = trim($attachment->post_content); // Used for file play length

       $output .= "<div class='audio-player'>" ;
       $output .= "<div id='audio-holder-$post_id-$counter' class='audio-file'></div>";
       $output .=  "<script type='text/javascript'>" . "\n";
       $output .=  "var so = new SWFObject('" . get_bloginfo('template_url') . "/includes/player.swf','player_" . $post_id . "_" . $counter ."',$audio_w,$audio_h,'8');" . "\n";
       $output .=  "so.addParam('allowfullscreen','true');" . "\n";
       $output .=  "so.addParam('allowscriptaccess','always');" . "\n";
       $output .=  "so.addParam('wmode','opaque');";
       $output .=  "so.addVariable('type','sound');" . "\n";
       $output .=  "so.addVariable('width','$audio_w');\n";
       $output .=  "so.addVariable('height','$audio_h');\n";
       $output .=  "so.addVariable('file','$path');\n";
       $output .=  "so.addVariable('volume','$volume');\n";
       $output .=  "so.addVariable('autostart','$auto');\n";
       $output .=  "so.addVariable('repeat','$repeat');\n";   
       //$output .=  "so.addVariable('skin','$skin');\n";
       $output .=  "so.addVariable('backcolor','$back');\n";
  	   $output .=  "so.addVariable('frontcolor','$front');\n";
  	   $output .=  "so.addVariable('lightcolor','$light');\n";
  	   
       if(!empty($duration)){
       // $output .=  "so.addVariable('duration',$duration);" . "\n";
       }
       $output .=  "so.write('audio-holder-$post_id-$counter');";
       $output .=  "</script>";
       
       if(!empty($title) AND $captions == 'true' AND $link == 'false'){
            $output .= "<span class='audio-title'>$title</span>";}
       
       if(!empty($title) AND $captions == 'true' AND $link == 'true'){
            $output .= "<span class='audio-title'><a href='$path'>$title</a></span>";}
       
       if(!empty($caption) AND $captions == 'true' ){
           $output .= "<span class='audio-excerpt'>$caption</span>";
        }
        $output .= "</div>"; 
        
		
        if($limit_players == $counter){break;}
		
       
    }
    $output .= "</div>";   
    return $output;
  
 
}

function woo_media_add($instance){
    
    $id = $instance['post_id'];
    $video_w = $instance['video_width'];
    $video_h = $instance['video_height'];
    
    $audio_w = $instance['audio_width'];
    $audio_h = $instance['audio_height'];  
	
    $image_w = $instance['image_width'];
    $image_h = $instance['image_height'];
    
    $limit_players = $instance['limit_players'];
	$limit_pictures = $instance['limit_pictures'];
	
	$widget_id = $instance['widget_id'];

    //Video
    if(woo_get_embed('embed',$video_w,$video_h))
     { 
        echo woo_get_embed('embed',$video_w,$video_h,"unit video-unit");  
     }
     
     //Pictures
     if(woo_attachments($instance)){
         echo woo_attachments($instance,$image_w,$image_h,$limit_pictures);
     }

     //Audio
     if(woo_mp3_player($id))
     {
         echo woo_mp3_player($id,$audio_w,$audio_h,$limit_players,$widget_id);
     }
 
}


// Single player insert
function woo_insert_player($id,$width = 220,$height = 19,$limit = 0){  
      
 	$id = intval($id);
	
   	//Defaults
    $volume = "50";
    $auto = "false";
    $repeat = "false";
    
    //Custom
    $back = get_option('woo_player_back');
    $front = get_option('woo_player_front');
    $light = get_option('woo_player_light');
    $link = get_option('woo_player_link');
    $captions = get_option('woo_player_captions');
    
    $counter = 0;    
    $output .=  '<div class="unit audio-unit">'; 

      
       $title = get_the_title($id);
       //$caption = get_the_exceprt($id);
       $path = wp_get_attachment_url($id);
       $duration = get_the_content($id); // Used for file play length

       $output .= "<div class='audio-player stand-alone'>" ;
       $output .= "<div id='audio-holder-$id' class='audio-file'></div>";
       $output .=  "<script type='text/javascript'>" . "\n";
       $output .=  "var so = new SWFObject('" . get_bloginfo('template_url') . "/includes/player.swf','player_" . $id . "',$width,$height,'8');" . "\n";
       $output .=  "so.addParam('allowfullscreen','true');" . "\n";
       $output .=  "so.addParam('allowscriptaccess','always');" . "\n";
       $output .=  "so.addParam('wmode','opaque');";
       $output .=  "so.addVariable('type','sound');" . "\n";
       $output .=  "so.addVariable('width','$width');\n";
       $output .=  "so.addVariable('height','$height');\n";
       $output .=  "so.addVariable('file','$path');\n";
       $output .=  "so.addVariable('volume','$volume');\n";
       $output .=  "so.addVariable('autostart','$auto');\n";
       $output .=  "so.addVariable('repeat','$repeat');\n";   
       //$output .=  "so.addVariable('skin','$skin');\n";
       $output .=  "so.addVariable('backcolor','$back');\n";
  	   $output .=  "so.addVariable('frontcolor','$front');\n";
  	   $output .=  "so.addVariable('lightcolor','$light');\n";
  	   
       if(!empty($duration)){
       // $output .=  "so.addVariable('duration',$duration);" . "\n";
       }
       $output .=  "so.write('audio-holder-$id');";
       $output .=  "</script>";
	   
	   /*
       
       if(!empty($title) AND $captions == 'true' AND $link == 'false'){
            $output .= "<span class='audio-title'>$title</span>";}
       
       if(!empty($title) AND $captions == 'true' AND $link == 'true'){
            $output .= "<span class='audio-title'><a href='$path'>$title</a></span>";}
       
       if(!empty($caption) AND $captions == 'true' ){
           $output .= "<span class='audio-excerpt'>$caption</span>";
        }
		*/
		
        $output .= "</div>"; 
       
    
    $output .= "</div>";   
    return $output;
  
 
}

        
function quickadd_head() { 
?>
<link rel="stylesheet" href="http://colourlovers.com.s3.amazonaws.com/COLOURloversColorPicker/COLOURloversColorPicker.css" type="text/css" media="all" />
<script type="text/JavaScript" src="http://colourlovers.com.s3.amazonaws.com/COLOURloversColorPicker/js/COLOURloversColorPicker.js"></script>

<?php }

function quickadd_foot() { ?>
<div id="CLCP" class="CLCP"></div>
<script type="text/JavaScript">
_whichField = "hexValue_0";
CLCPHandler = function(_hex) {
// This function gets called by the picker when the sliders are being dragged. The variable _hex contains the current hex value from the picker
// This code serves as an example only, here we use it to do three things:
// Here we simply drop the variable _hex into the input field, so we can see what the hex value coming from the picker is:
document.getElementById(_whichField).value = _hex;
}
// Settings:
_CLCPdisplay = "none"; // Values: "none", "block". Default "none"
_CLCPisDraggable = true; // Values: true, false. Default true
_CLCPposition = "absolute"; // Values: "absolute", "relative". Default "absolute"
_CLCPinitHex = "0039B3"; // Values: Any valid hex value. Default "ffffff"
CLCPinitPicker();
</script> 
<?php
}


add_action('admin_head', 'quickadd_head');    
add_action('admin_footer', 'quickadd_foot');       
    
?>